/*--------------------------------------------------------------------------
* GDI+̃bp[
* 
* created by Nekorabbit
*--------------------------------------------------------------------------*/
#pragma once

#include <objidl.h>
#include <gdiplus.h>
#include "GDICapture.h"

#undef min
#undef max

namespace chkimg {

void multi_byte_to_wchar(
	const std::string& value, std::wstring& out
) {
	int wideCharLen = ::MultiByteToWideChar(CP_ACP, 0, value.c_str(), -1, NULL, 0);
	out.resize(wideCharLen);
	out.resize(::MultiByteToWideChar(CP_ACP, 0, value.c_str(), -1, &out[0], wideCharLen));
}

void multi_byte_to_wchar(
	const char* value, std::wstring& out
) {
	int wideCharLen = ::MultiByteToWideChar(CP_ACP, 0, value, -1, NULL, 0);
	out.resize(wideCharLen);
	out.resize(::MultiByteToWideChar(CP_ACP, 0, value, -1, &out[0], wideCharLen));
}

//////////////////////////////////////////////////////////////////////////
// Encoder
//////////////////////////////////////////////////////////////////////////

GDIEncoder::GDIEncoder()
{
	if(initEncoderClsid() == false)
		throw "GR[_܂";
}

// ⏕֐
void GDIEncoder::saveBitmapAsBMP(Gdiplus::Bitmap* bitmap, const char* filename_) const {
	std::wstring filename; multi_byte_to_wchar(filename_, filename);
	bitmap->Save(filename.c_str(), &bmpEncoder, NULL);
}
void GDIEncoder::saveBitmapAsPNG(Gdiplus::Bitmap* bitmap, const char* filename_) const {
	std::wstring filename; multi_byte_to_wchar(filename_, filename);
	bitmap->Save(filename.c_str(), &pngEncoder, NULL);
}
void GDIEncoder::saveBitmapAsJPEG(Gdiplus::Bitmap* bitmap, const char* filename_) const {
	std::wstring filename; multi_byte_to_wchar(filename_, filename);
	bitmap->Save(filename.c_str(), &jpegEncoder, NULL);
}

bool GDIEncoder::initEncoderClsid() {
	UINT  num = 0, size = 0;

	Gdiplus::GetImageEncodersSize(&num, &size);
	if (size == 0)
		return false;

	Gdiplus::ImageCodecInfo* pImageCodecInfo = (Gdiplus::ImageCodecInfo*)malloc(size);
	if (pImageCodecInfo == NULL)
		return false;  // Failure

	Gdiplus::GetImageEncoders(num, size, pImageCodecInfo);

	int numEncoders = 0;
	for(UINT j = 0; j < num; ++j) {
		if (wcscmp(pImageCodecInfo[j].MimeType, L"image/bmp") == 0) {
			bmpEncoder = pImageCodecInfo[j].Clsid;
			++numEncoders;
		}
		else if (wcscmp(pImageCodecInfo[j].MimeType, L"image/png") == 0) {
			pngEncoder = pImageCodecInfo[j].Clsid;
			++numEncoders;
		}
		else if (wcscmp(pImageCodecInfo[j].MimeType, L"image/jpeg") == 0) {
			jpegEncoder = pImageCodecInfo[j].Clsid;
			++numEncoders;
		}
	}

	free(pImageCodecInfo);
	return numEncoders == 3;
}

//////////////////////////////////////////////////////////////////////////
// 摜t@CÍ
//////////////////////////////////////////////////////////////////////////

static DWORD g_encrypt_key = 0xE8F29FACUL;

void xorEncrypt(void* data, int len) {
	DWORD* ptr = (DWORD*)data;
	for(int i = 0; i < (len/sizeof(DWORD)); ++i) {
		ptr[i] ^= g_encrypt_key;
	}
}

//////////////////////////////////////////////////////////////////////////
// ⏕֐
//////////////////////////////////////////////////////////////////////////

void ForceIntoBoundingBox(RECT* rect,
						  int bleft, int btop, int bw, int bh)
{
	rect->top = std::max<int>(rect->top, btop);
	rect->left = std::max<int>(rect->left, bleft);
	rect->right = std::min<int>(rect->right, btop + bw);
	rect->bottom = std::min<int>(rect->bottom, btop + bh);
}

// 摜ǂݍ񂾃ubNIStream쐬
IStream * createFileStream(const char *filepath, bool decrypt)
{
	// 摜t@CI[v
	const HANDLE hFile = CreateFile(filepath, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if(hFile == INVALID_HANDLE_VALUE)
		throw_exception("t@C܂: %s", filepath);

	// t@CTCY擾
	const DWORD dwFileSize = GetFileSize(hFile, NULL);
	// 摜t@Cf[^i[pubNm
	const HGLOBAL hBuf = GlobalAlloc(GMEM_MOVEABLE, dwFileSize);
	if(hBuf == NULL)
		throw_exception("GlobalAllocɎs");
		
	// ubNbNAhX擾
	const LPVOID lpBuf = GlobalLock(hBuf);
	// 摜t@C̃f[^ubNɓǂݍ
	DWORD dwLoadSize;
	ReadFile(hFile, lpBuf, dwFileSize, &dwLoadSize, NULL);
	if(dwFileSize != dwLoadSize)
		throw_exception("ReadFileɎs");
	CloseHandle(hFile);
	// ubÑbN
	GlobalUnlock(hBuf);

	// KvȂ畜
	if(decrypt) {
		xorEncrypt(lpBuf, dwLoadSize);
	}

	// ubNIStream쐬
	IStream * isFile;
	HRESULT hr = CreateStreamOnHGlobal(hBuf, TRUE, &isFile);
	if(FAILED(hr) || isFile == NULL)
		throw_exception("CreateStreamOnHGlobalɎs");
	// IStreamԂ
	return isFile;
}

// 摜ǂݍ񂾃ubNIStream쐬
IStream * createResourceStream(HMODULE module, WORD id)
{
	HRSRC hRsc = FindResource(module, MAKEINTRESOURCE(id), "PNG");
	if(hRsc == NULL)
		throw_exception("\[X܂");
	
	// ܂Aۂ͉ȂA̎擾֐Ȃ񂾂ǂ
	DWORD dwFileSize = SizeofResource(module, hRsc);
	if(dwFileSize == 0)
		throw_exception("\[X̃TCY擾Ɏs");
	
	// ܂Aۂ͉ȂA̎擾֐Ȃ񂾂ǂ
	HGLOBAL hData = LoadResource(module, hRsc);
	if(hData == NULL)
		throw_exception("\[X̃[hɎs");
	
	// ܂Aۂ͉ȂA̎擾֐Ȃ񂾂ǂ
	LPVOID pData = LockResource(hData);
	if(pData == NULL)
		throw_exception("\[X̃bNɎs");

	// 摜t@Cf[^i[pubNm
	const HGLOBAL hBuf = GlobalAlloc(GMEM_MOVEABLE, dwFileSize);
	if(hBuf == NULL)
		throw_exception("GlobalAllocɎs");
		
	// ubNbNAhX擾
	const LPVOID lpBuf = GlobalLock(hBuf);
	// 摜t@C̃f[^ubNɓǂݍ
	memcpy(lpBuf, pData, dwFileSize);
	// ubÑbN
	GlobalUnlock(hBuf);

	// ubNIStream쐬
	IStream * isFile;
	HRESULT hr = CreateStreamOnHGlobal(hBuf, TRUE, &isFile);
	if(FAILED(hr) || isFile == NULL)
		throw_exception("CreateStreamOnHGlobalɎs");
	// IStreamԂ
	return isFile;
}

GDIBitmap* copyBitmap(HDC winDC, int x, int y, int w, int h, double scale) {
	int dst_w = w * scale;
	int dst_h = h * scale;
	
	// Rs[̃rbg}bv쐬
	GDIBitmap* bmp = new GDIBitmap(dst_w, dst_h);
	try {
		//Graphics̍쐬
		Gdiplus::Graphics g(bmp->ptr());
		//Graphics̃foCXReLXg擾
		HDC hDC = g.GetHDC();
		//Bitmapɉ摜Rs[
		if(scale == 1.0) {
			if(BitBlt(hDC, 0, 0, w, h, winDC, x, y, SRCCOPY) == 0)
				throw_exception("BitBltɎs");
		}
		else {
			if(StretchBlt(hDC, 0, 0, dst_w, dst_h, winDC, x, y, w, h, SRCCOPY) == 0)
				throw_exception("StretchBltɎs");
		}
		//
		g.ReleaseHDC(hDC);
	}
	catch(const char* str) {
		delete bmp; bmp = NULL;
		throw str;
	}

	return bmp;
}

// ֐A
// ۂɃLv`Wrectɓ
GDIBitmap* captureScreen(HWND hWnd, RECT* rect, double scale, bool backgroud_mode) {
	// fXNgbvXN[̃foCXReLXg쐬
	HDC winDC;
	if(hWnd != NULL) {
		// EBhE
		winDC = GetWindowDC(hWnd);
		if(winDC == NULL)
				throw_exception("GetWindowDCɎs");
	}
	else {
		// fXNgbv
		winDC = GetDC(NULL);
		if(winDC == NULL)
				throw_exception("GetDCɎs");
	}
 
	// ͈͂EBhEɎ߂
	RECT wndRect;
	if(hWnd != NULL) {
		GetWindowRect(hWnd, &wndRect);
		ForceIntoBoundingBox(rect,
			0, 0, wndRect.right - wndRect.left, wndRect.bottom - wndRect.top);
	}
	else {
		ForceIntoBoundingBox(rect,
			GetSystemMetrics(SM_XVIRTUALSCREEN), GetSystemMetrics(SM_YVIRTUALSCREEN),
			GetSystemMetrics(SM_CXVIRTUALSCREEN), GetSystemMetrics(SM_CYVIRTUALSCREEN));
	}
	int x = rect->left, y = rect->top;
	int w = rect->right - rect->left, h = rect->bottom - rect->top;
	
	GDIBitmap* bmp = NULL;
	GDIBitmap* tmp = NULL;

	if(hWnd != NULL && !backgroud_mode) {
		// ڎȂꍇ̂PrintWindowŎĂ
		int win_w = wndRect.right - wndRect.left;
		int win_h = wndRect.bottom - wndRect.top;
		tmp = new GDIBitmap(win_w, win_h);
		try {
			//Graphics̍쐬
			Gdiplus::Graphics g(tmp->ptr());
			//Graphics̃foCXReLXg擾
			HDC hDC = g.GetHDC();
			if(PrintWindow(hWnd, hDC, 0) == 0)
				throw_exception("PrintWindowɎs");

			if(x == 0 && y == 0 && w == win_w && h == win_h && scale == 1.0) {
				// EBhEŜ̂܂܂̑傫Ȃ̂ŃRs[Ȃ
				bmp = tmp;
			}
			else {
				// PrintWindowbitmapRs[
				bmp = copyBitmap(hDC, x, y, w, h, scale);
			}
			//
			g.ReleaseHDC(hDC);
		}
		catch(const char* str) {
			delete tmp; tmp = NULL;
			throw str;
		}
	}
	else {
		// ڃRs[
		bmp = copyBitmap(winDC, x, y, w, h, scale);
	}

	// 
	ReleaseDC(hWnd, winDC);
	if(tmp != NULL && tmp != bmp) {
		delete tmp; tmp = NULL;
	}

	return bmp;
}

GDIBitmap* captureScreen(HWND hWnd, double scale) {
	RECT rect;
	if(hWnd == NULL) {
		// fXNgbvŜLv`
		rect.left = GetSystemMetrics(SM_XVIRTUALSCREEN);
		rect.top = GetSystemMetrics(SM_YVIRTUALSCREEN);
		rect.right = rect.left + GetSystemMetrics(SM_CXVIRTUALSCREEN);
		rect.bottom = rect.top + GetSystemMetrics(SM_CYVIRTUALSCREEN);
	}
	else {
		GetWindowRect(hWnd, &rect);
		rect.right -= rect.left; rect.left = 0;
		rect.bottom -= rect.top; rect.top = 0;
	}
	return captureScreen(hWnd, &rect, scale);
}

} // chkimg
